from formatting import *
class Product:

    last_serial_number=0
    
    def __init__(self,name,price,*dimensions,**kwargs):
        self._name=name
        self.price=price
        self._dimensions=dimensions
        self._kwargs=kwargs
        Product.last_serial_number+=1
        self._serial_number=Product.last_serial_number

    #Properties
    @property
    @format_as_character
    def name(self):
        return self._name
    
    @property
    @format_as_currency
    def price(self):
        return self._price

    @price.setter
    def price(self,value):
        self.check_price(value)
        self._price=value

    def check_price(self,value):
        if value < 0:
            raise ValueError("Negative values not permitted")

    #Class functions
    def printProduct(self):
        print("Product number: ",self._serial_number)
        #print(self.getName(),self.getPrice())
        print(self.name,self.price)
        print("Weight (g), height (cm), length(cm), width(cm): "
              ,self._dimensions)
        for key,value in self._kwargs.items():
            print(key,": ",value) #include the : for formatting purposes

    @classmethod
    def _get_last_serial_number(cls):#the cls parameter refers to the class
        return cls.last_serial_number

    #Named constructors
    @classmethod
    def basic_product(cls,name,price):
        return cls(name,price)
    @classmethod
    def product_with_dimensions(cls,name,price,*dimensions):
        return cls(name,price,*dimensions)
